%% Three Kingdoms Optimization Algorithm (TKOA)

function [best_X,Convergence_curve] = TKOA(N,MaxFEs,lb,ub,dim,fobj)
if(size(lb,2)==1)
    lb=lb.*ones(1,dim);
    ub=ub.*ones(1,dim);
end
best_X=zeros(1,dim);
best_fit=inf; %change this to -inf for maximization problems
newX=zeros(N,dim);
newfit=inf.*ones(1,N);
FEs=0;
%% 1. Ascent of might
X = lb + ub.*rand(N,dim);
fit= zeros(1,N);
for i=1:N
    fit(1,i) = fobj(X(i,:));
    FEs=FEs+1;
    if fit(1,i)<best_fit
        best_fit=fit(1,i);
        best_X=X(i,:);
    end
end
V=4;
Time = 1;
Convergence_curve = [];
Convergence_curve(Time) = best_fit;

while FEs <= MaxFEs
    [~,SmellIndex] =sort(fit);
    abc_X=X(SmellIndex(1:3),:);
    power=sqrt((FEs-1)/MaxFEs);
    currentPower=sech(mapminmax(abs(fit-best_fit),0,1).*V);
    for i=1:N
        powerLine=(power)^(1-tan(pi*(rand-0.5))/MaxFEs);
        %% 2. Joint confrontation
        if powerLine<rand
            for j=1:dim
                r1=unifrnd(0,1);
                r2=unifrnd(0,1);
                temp1=r1.*abc_X(2 ,j)+(1-r1).*X(i,j)+rand*((ub(j)-lb(j))*rand+lb(j));
                temp2=r2.*abc_X(3 ,j)+(1-r2).*X(i,j)+rand*((ub(j)-lb(j))*rand+lb(j));
                wight=rand;
                newX(i,j)=wight*temp1+(1-wight)*temp2;
            end
            %% 3. Three legged tripod
        else
            Index=randi([1,3]);
            rr = floor(rand()* N) + 1;
            while rr ==i,rr = floor(rand()* N) + 1;end
            [m,~] = min([fit(1,rr),fit(1,i)]);
            if m == fit(1,rr), betterX=X(rr,:); else, betterX=X(i,:); end
            moveStep1=rand(1,dim).* (abc_X(Index,:)-betterX);
            moveStep2=rand(1,dim).* (betterX - X(i,:)); %%
            newX(i,:)=betterX+(moveStep1+moveStep2).*Levy(dim); % ̽ Levy(dim)

        end
        % Boundary absorption
        for j=1:dim
            if newX(i,j)>ub(j)
                r_u = 0.1*rand();
                newX(i,j)=(1-r_u)*ub(j)+r_u*newX(i,j);
            elseif newX(i,j)<lb(j)
                r_l = 0.1*rand();
                newX(i,j)=(1-r_l)*lb(j)+r_l*newX(i,j);
            end
        end
        newfit(1,i) = fobj(newX(i,:));
        FEs=FEs+1;
        if newfit(1,i)<fit(1,i)
            X(i,:)=newX(i,:);
            fit(1,i)=newfit(1,i);
        end
        if newfit(1,i)<best_fit
            best_X=newX(i,:);
            best_fit=newfit(1,i);
        end
        %% 4. Whole country united
        for j = 1:dim
            R2=rand;
            if currentPower(i)>R2
                newX(i,j)= X(i,j);
            else
                newX(i,j)=power*best_X(1,j)+(1-power)*X(i,j)+rand*(best_X(1,j)-X(1,j));
                % Boundary absorption
                if newX(i,j)>ub(j)
                    r_u = 0.1*rand();
                    newX(i,j)=(1-r_u)*ub(j)+r_u*newX(i,j);
                elseif newX(i,j)<lb(j)
                    r_l = 0.1*rand();
                    newX(i,j)=(1-r_l)*lb(j)+r_l*newX(i,j);
                end
            end
        end
        newfit(1,i) = fobj(newX(i,:));
        FEs=FEs+1;
        if newfit(1,i)<fit(1,i)
            X(i,:)=newX(i,:);
            fit(1,i)=newfit(1,i);
        end
        if newfit(1,i)<best_fit
            best_X=newX(i,:);
            best_fit=newfit(1,i);
        end
    end
    Time=Time+1;
    Convergence_curve(Time) = best_fit;
end
end
function o=Levy(d)
beta=1.5;
sigma=(gamma(1+beta)*sin(pi*beta/2)/(gamma((1+beta)/2)*beta*2^((beta-1)/2)))^(1/beta);
u=randn(1,d)*sigma;v=randn(1,d);step=u./abs(v).^(1/beta);
o=step;
end
